# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to change jobs/jobsets parameters."""

import sys
import getopt

import path
import set_options
import set_options_w
from tables.job_main import job_main
from tables.job_main_s import job_main_s


def set(sql_session, current_cwd, current_cwd_cal, arguments, workload=None):
    """Change job/jobset parameters.

    Arguments:
    sql_session -- SQLAlchemy session
    current_cwd -- current working jobset (a path.Path object)
    arguments -- list of arguments given to the set command (list
                 of jobs/jobsets)
    workload -- workload to use

    """
    # Parse the parameters
    try:
        if workload is None:
            optlist, args = set_options.parse_args(arguments)
        else:
            optlist, args = set_options_w.parse_args(arguments)
    except getopt.GetoptError, err:
        sys.stderr.write(_("set: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            set_options.usage() if workload is None else set_options_w.usage()
            return 0
    paths = list()
    if args:
        for arg in args:
            paths.extend(path.get_paths(sql_session, arg, current_cwd,
                                        workload=workload))
    else:
        sys.stderr.write(_("set: missing job or jobset name\n"))
        return 1
    if not paths:
        sys.stderr.write(_("set: no such job or jobset\n"))
        return 1
    session = sql_session.open_session()
    error = False
    for p in paths:
        if workload is None:
            query = session.query(job_main)
        else:
            query = session.query(job_main_s)
            query = query.filter(job_main_s.workload_date == workload)
        query = query.filter_by(id=p.id[-1])
        try:
            job = query.one()
        except:
            sys.stderr.write(_("set: `%s': no such job or jobset\n") % p)
            error = True
            continue
        session.add(job)
        if workload is None:
            ret = set_options.set(session, current_cwd, current_cwd_cal, job,
                                  optlist)
        else:
            ret = set_options_w.set(session, job, optlist, workload)
        if ret:
            sql_session.cancel_session(session)
            return 1
    sql_session.close_session(session)
    return 0 if not error else 1
