/* Schedwi
   Copyright (C) 2007-2013 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * startjob_request.h -- Build the string which contains the network request
 *                       to start a job
 */

#ifndef _STARTJOB_REQUEST_H
#define _STARTJOB_REQUEST_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <net_utils.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _startjob_request {
	lwc_LL *parameters;
	lwc_LL *env;
	lwc_LL *args;
};
typedef struct _startjob_request startjob_request;
typedef struct _startjob_request *startjob_request_ptr;


extern startjob_request_ptr startjob_request_new OF(());
extern void startjob_request_destroy OF((startjob_request_ptr ptr));
extern int startjob_request_add_argument OF((startjob_request_ptr ptr,
				const char *pos, unsigned int len_pos,
				const char *val, unsigned int len_val));
extern int startjob_request_add_environment OF((startjob_request_ptr ptr,
					const char *pos,
					const char *key, const char *value));
extern int startjob_request_add_parameter_string OF((startjob_request_ptr ptr,
					const char *name,
					const char *val,
					unsigned int len_val));
extern int startjob_request_add_parameter_bool OF((startjob_request_ptr ptr,
					const char *name, char val));
extern int startjob_request_add_jobid OF((startjob_request_ptr ptr,
					const char *workload,
					const char *job_id_str,
					unsigned int len_job_id_str));
extern int net_write_request OF((startjob_request_ptr ptr,
				schedwi_BIO *b, const char *module_name));

#define startjob_request_add_command(X,VAL,LEN) startjob_request_add_parameter_string(X,"command",VAL,LEN)
#define startjob_request_add_username(X,VAL,LEN) startjob_request_add_parameter_string(X,"user",VAL,LEN)
#define startjob_request_add_fileout(X,VAL,LEN) startjob_request_add_parameter_string(X,"stdout",VAL,LEN)
#define startjob_request_add_filerr(X,VAL,LEN) startjob_request_add_parameter_string(X,"stderr",VAL,LEN)
#define startjob_request_add_cgroup(X,VAL,LEN) startjob_request_add_parameter_string(X,"cgroup",VAL,LEN)
#define startjob_request_add_loadenv(X,VAL,LEN) startjob_request_add_parameter_bool(X,"user env",((VAL)[0]=='0')?0:1)
#define startjob_request_add_detach(X,VAL,LEN) startjob_request_add_parameter_bool(X,"detach",((VAL)[0]=='0')?0:1)
#define startjob_request_add_filename(X,VAL,LEN) startjob_request_add_parameter_string(X,"file",VAL,LEN)


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* startjob_request.h */

/*-----------------============== End Of File ==============-----------------*/
