/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* job_status.h -- Manage the jobs/jobsets status */

#ifndef _JOB_STATUS_H
#define _JOB_STATUS_H

#include <schedwi.h>
#include <schedwi_time.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int job_status_set OF((	unsigned long long int id,
				const char *path,
				int workload_date,
				job_status_state status,
				unsigned int status_time,
				long int duration,
				int retry_num,
				int wait_reason,
				const char *error_message));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_status.h */

/*-----------------============== End Of File ==============-----------------*/
