# Schedwi
# Copyright (C) 2011-2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String
from sqlalchemy.orm import relationship, backref

from base import Base, convert2unicode

from job_start_limit import job_start_limit
from job_max_duration import job_max_duration
from job_retries import job_retries
from job_retries_interval import job_retries_interval
from job_username import job_username
from job_file_out import job_file_out
from job_file_err import job_file_err
from job_control_group import job_control_group
from job_loadenv import job_loadenv
from job_detach import job_detach
from job_manual import job_manual
from job_manual_command import job_manual_command
from job_success_return_code import job_success_return_code
from job_command import job_command
from job_arguments import job_arguments
from job_environment import job_environment
from job_host import job_host
from constraint_file import constraint_file
from job_stat import job_stat
from link import link


class job_main(Base):
    __tablename__ = 'job_main'

    id = Column(Integer, primary_key=True)
    parent = Column(Integer)
    name = Column(String(255))
    type = Column(Integer)   # 0 (jobset) or 1 (job)
    enabled = Column(Integer)
    has_env = Column(Integer)
    description = Column(Text)
    x = Column(Integer)
    y = Column(Integer)
    cal_id = Column(Integer)
    start_time = Column(Integer)

    job_start_limit = relationship(job_start_limit,
                               uselist=False,
                               backref="job_main",
                               cascade="all, delete, delete-orphan")
    job_max_duration = relationship(job_max_duration,
                                uselist=False,
                                backref="job_main",
                                cascade="all, delete, delete-orphan")
    job_retries = relationship(job_retries,
                           uselist=False,
                           backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_retries_interval = relationship(job_retries_interval,
                                    uselist=False,
                                    backref="job_main",
                                    cascade="all, delete, delete-orphan")
    job_username = relationship(job_username,
                            uselist=False,
                            backref="job_main",
                            cascade="all, delete, delete-orphan")
    job_file_out = relationship(job_file_out,
                            uselist=False,
                            backref="job_main",
                            cascade="all, delete, delete-orphan")
    job_file_err = relationship(job_file_err,
                            uselist=False,
                            backref="job_main",
                            cascade="all, delete, delete-orphan")
    job_control_group = relationship(job_control_group,
                            uselist=False,
                            backref="job_main",
                            cascade="all, delete, delete-orphan")
    job_loadenv = relationship(job_loadenv, uselist=False, backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_detach = relationship(job_detach, uselist=False, backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_manual = relationship(job_manual, uselist=False, backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_manual_command = relationship(job_manual_command, uselist=False,
                           backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_success_return_code = relationship(job_success_return_code,
                                       uselist=False,
                                       backref="job_main",
                                       cascade="all, delete, delete-orphan")
    job_command = relationship(job_command,
                           uselist=False,
                           backref="job_main",
                           cascade="all, delete, delete-orphan")
    job_arguments = relationship(job_arguments,
                                 order_by=job_arguments.position,
                                 backref="job_main",
                                 cascade="all, delete, delete-orphan")
    job_environment = relationship(job_environment,
                               order_by=job_environment.position,
                               backref="job_main",
                               cascade="all, delete, delete-orphan")
    job_host = relationship(job_host, uselist=False, backref="job_main",
                        cascade="all, delete, delete-orphan")
    constraint_file = relationship(constraint_file,
                                   order_by=constraint_file.exist,
                                   backref="job_main",
                                   cascade="all, delete, delete-orphan")
    job_stat = relationship(job_stat, uselist=False, backref="job_main",
                            cascade="all, delete, delete-orphan")
    links = relationship(link, backref="job_main",
                         primaryjoin=link.job_id_source == id,
                         cascade="all, delete, delete-orphan")
    link_targets = relationship(link,
                     primaryjoin=link.job_id_destination == id,
                     cascade="all, delete, delete-orphan")

    def __init__(self, parent, name, type, enabled, has_env,
                 description, x, y, cal_id, start_time):
        self.parent = parent
        self.name = convert2unicode(name)
        self.type = type
        self.enabled = enabled
        self.has_env = has_env
        self.description = convert2unicode(description)
        self.x = x
        self.y = y
        self.cal_id = cal_id
        self.start_time = start_time

    def copy(self):
        j = job_main(self.parent, self.name, self.type, self.enabled,
                     self.has_env, self.description, self.x, self.y,
                     self.cal_id, self.start_time)
        if self.job_start_limit:
            j.job_start_limit = self.job_start_limit.copy()
        else:
            j.job_start_limit = self.job_start_limit
        if self.job_max_duration:
            j.job_max_duration = self.job_max_duration.copy()
        else:
            j.job_max_duration = self.job_max_duration
        if self.job_retries:
            j.job_retries = self.job_retries.copy()
        else:
            j.job_retries = self.job_retries
        if self.job_retries_interval:
            j.job_retries_interval = self.job_retries_interval.copy()
        else:
            j.job_retries_interval = self.job_retries_interval
        if self.job_username:
            j.job_username = self.job_username.copy()
        else:
            j.job_username = self.job_username
        if self.job_file_out:
            j.job_file_out = self.job_file_out.copy()
        else:
            j.job_file_out = self.job_file_out
        if self.job_file_err:
            j.job_file_err = self.job_file_err.copy()
        else:
            j.job_file_err = self.job_file_err
        if self.job_control_group:
            j.job_control_group = self.job_control_group.copy()
        else:
            j.job_control_group = self.job_control_group
        if self.job_loadenv:
            j.job_loadenv = self.job_loadenv.copy()
        else:
            j.job_loadenv = self.job_loadenv
        if self.job_detach:
            j.job_detach = self.job_detach.copy()
        else:
            j.job_detach = self.job_detach
        if self.job_manual:
            j.job_manual = self.job_manual.copy()
        else:
            j.job_manual = self.job_manual
        if self.job_manual_command:
            j.job_manual_command = self.job_manual_command.copy()
        else:
            j.job_manual_command = self.job_manual_command
        if self.job_success_return_code:
            j.job_success_return_code = self.job_success_return_code.copy()
        else:
            j.job_success_return_code = self.job_success_return_code
        if self.job_command:
            j.job_command = self.job_command.copy()
        else:
            j.job_command = self.job_command
        j.job_arguments = list()
        for arg in self.job_arguments:
            j.job_arguments.append(arg.copy())
        j.job_environment = list()
        for env in self.job_environment:
            j.job_environment.append(env.copy())
        if self.job_host:
            j.job_host = self.job_host.copy()
        else:
            j.job_host = self.job_host
        j.constraint_file = list()
        for f in self.constraint_file:
            j.constraint_file.append(f.copy())
        j.job_stat = job_stat(0, 0, 0, 0)
        j.links = list()
        for link in self.links:
            j.links.append(link.copy())
        return j
