# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column
from sqlalchemy.types import Integer, Text, String
from sqlalchemy.orm import relation, backref

from base import Base, convert2unicode

from host_environment import host_environment


class hosts(Base):
    __tablename__ = 'hosts'

    id = Column(Integer, primary_key=True)
    hostname = Column(String(255))
    portnum = Column(String(50))
    sslenable = Column(Integer)
    sslcert = Column(Text)
    description = Column(Text)

    host_environment = relation(host_environment,
                                order_by=host_environment.position,
                                backref="hosts",
                                cascade="all, delete, delete-orphan")

    def __init__(self, hostname, portnum, sslenable, sslcert, description):
        self.hostname = convert2unicode(hostname)
        if isinstance(portnum, int):
            self.portnum = portnum
        else:
            self.portnum = convert2unicode(portnum)
        self.sslenable = sslenable
        self.sslcert = convert2unicode(sslcert)
        self.description = convert2unicode(description)

    def __str__(self):
        if self.hostname.find(':') >= 0:
            return "[%s]:%s" % (self.hostname, self.portnum)
        else:
            return "%s:%s" % (self.hostname, self.portnum)
