# Schedwi
# Copyright (C) 2011-2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to stop jobs and jobsets."""

import sys
import getopt

import path
from tables.commands import commands
import parse_config
import config
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: stop [OPTIONS]... JOB|JOBSET...
        Force the stop of JOBs and JOBSETs.  For a jobset, its children will
        recursively be stopped.

        Option:
          -h, --help  display this help.
    """))


def stop_id(session, job_id, workload):
    query = session.query(commands).filter(commands.job_id == job_id)
    query = query.filter(commands.workload_date == workload)
    query = query.filter(commands.command_status == 0)
    query = query.filter(commands.command == 2)
    if not query.count():
        c = commands(job_id, parse_config.DBI_USER, 0, 2, 0, workload)
        session.add(c)


def stop(sql_session, current_cwd, arguments, workload):
    """Start jobs and jobsets.

    Arguments:
    sql_session -- SQLAlchemy session
    current_cwd -- current working jobset (a path.Path object)
    arguments -- list of arguments given to the stop command (list
                 of jobs/jobsets)
    workload -- workload to use

    """
    try:
        optlist, args = getopt.getopt(arguments, "h", ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write(_("stop: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    paths = list()
    if args:
        for arg in args:
            p = path.get_paths(sql_session, arg, current_cwd,
                               workload=workload)
            # An argument is an unknow path
            if not p:
                sys.stderr.write(_("stop: `%s': no such job or jobset\n")
                                 % arg)
                return 1
            paths.extend(p)
    else:
        sys.stderr.write(_("stop: missing job or jobset operand\n"))
        return 1
    session = sql_session.open_session()
    for p in paths:
        stop_id(session, p.id[-1], workload)
    sql_session.close_session(session)
    if config.ISATTY:
        print _("This may take up to a minute to be taken into account")
    return 0
