# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to remove hosts."""

import sys
import getopt

import host_utils
import whatuses
from help import print_trim


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: rm HOST...
        Remove each specified host.  HOST must have the following format:
           HOSTNAME[:PORT]
        For IPv6, the address must be enclosed between square brackets (ie.
        [fe80::210:a2ff:fa1d:aabb:ccdd]:2006)

        Option:
          -h, --help  display this help.
    """))


def rm(sql_session, arguments):
    """Remove hosts.

    Arguments:
    sql_session -- SQLAlchemy session
    arguments -- list of arguments given to the rm command (list of hosts)

    """
    try:
        optlist, args = getopt.getopt(arguments, "h", ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write(_("rm: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    if not args:
        sys.stderr.write(_("rm: missing operand\n"))
        return 1
    session = sql_session.open_session()
    error = False
    for a in args:
        host_list = host_utils.name2host_list(session, a)
        if not host_list:
            sys.stderr.write(_("rm: `%s': no such host\n") % a)
            error = True
        else:
            for h in host_list:
                if whatuses.is_used(session, h):
                    sys.stderr.write(
                 _("rm: `%s' is used (run `whatuses %s' for more details)\n")
                                        % (h, h))
                    error = True
                else:
                    session.delete(h)
    if error:
        sql_session.cancel_session(session)
        return 1
    sql_session.close_session(session)
    return 0
