# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module for readline auto-completion of hostnames."""


from tables.hosts import hosts


def complete(sql_session, text):
    text = text.decode('utf-8')
    try:
        i = text.rindex(':')
    except ValueError:
        host = text
        i = -1
    else:
        host = text[:i]
    session = sql_session.open_session()
    q = session.query(hosts.hostname, hosts.portnum)
    q = q.filter(hosts.hostname.like(host + '%'))
    q = q.order_by(hosts.hostname)
    lst = [h.encode('utf-8') + ':' + p.encode('utf-8') for h, p in q.all()
            if i == -1 or p.startswith(text[i + 1:])]
    sql_session.close_session(session)
    if len(lst) == 1:
        return [lst[0] + ' ']
    return lst
