# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module for readline auto-completion of environment group names."""

from tables.environments import environments
from tables.environments_s import environments_s


def complete(sql_session, text, workload=None):
    text = text.decode('utf-8')
    session = sql_session.open_session()
    if workload is None:
        q = session.query(environments)
        q = q.filter(environments.name.like(text + '%'))
        q = q.order_by(environments.name)
    else:
        q = session.query(environments_s)
        q = q.filter_by(workload_date=workload)
        q = q.filter(environments_s.name.like(text + '%'))
        q = q.order_by(environments_s.name)
    lst = q.all()
    sql_session.close_session(session)
    if len(lst) == 1:
        return [lst[0].name.encode('utf-8') + ' ']
    return [e.name.encode('utf-8') for e in lst]
