/* Schedwi
   Copyright (C) 2007-2010 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_constraint_file.c -- Get the constraint file for a job */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#else
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <sql_common.h>
#include <sql_constraint_file.h>


#define SQL_GET_CONSTRAINT_FILE "SELECT job_id,host_id,filename,exist FROM constraint_file_s WHERE workload_date=%d AND job_id=%ld"


/*
 * Get all the constraint files associated with the provided job.
 *
 * Return:
 *     0 --> No error.  rows contains the retrieved files and must be freed
 *           by the caller by
 *              lwc_delLL (rows, (void (*)(const void *)) sql_free_row);
 *    -1 --> Memory allocation error (if error_func() is not NULL, it is called
 *           with user_data_error_func as its first parameter and the error
 *           message as the second parameter)
 *    -2 --> SQL error (if error_func() is not NULL, it is called with
 *           user_data_error_func as its first parameter and the error message
 *           as the second parameter)
 */
int
sql_constraint_file_get (int workload_date, lwc_LL **rows,
			unsigned long long int job_id,
			void (*error_func)(void *, const char *, int),
			void *user_data_error_func)
{
	char *err_msg = NULL;
	int ret;

#if HAVE_ASSERT_H
	assert (rows != NULL);
#endif

	ret = sql_select (      NULL, NULL, &err_msg, NULL, rows,
				SQL_GET_CONSTRAINT_FILE,
				SQL_INT, (long int)workload_date,
				SQL_INT, (long int)job_id,
				SQL_END);

	if (ret != 0) {
		if (error_func != NULL) {
			error_func (user_data_error_func, err_msg, ret);
		}
		if (err_msg != NULL) {
			free (err_msg);
		}
		return ret;
	}
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
