/* Schedwi
   Copyright (C) 2007-2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_whoami.c -- Parse the `whoami' request */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include <lib_functions.h>
#include <net_utils_sock.h>
#include <reg_whoami.h>

int
reg_whoami (	int sock, const char *buff, ssize_t buff_len,
		const char *const *client_names)
{
	char *s, first;
	int i;

	if (client_names == NULL || client_names[0] == NULL) {
		s = "{ \"success\" : false, \"data\" : \"";
		net_write_sock (sock, s, schedwi_strlen (s));
		s = _("Cannot get agent IP/name details");
		net_write_sock (sock, s, schedwi_strlen (s));
		s = "\" }";
		net_write_sock (sock, s, schedwi_strlen (s));
		return -1;
	}

	s = "{ \"success\" : true, \"data\" : { \"ip\" : \"";
	net_write_sock (sock, s, schedwi_strlen (s));
	net_write_sock (sock, client_names[0],
			schedwi_strlen (client_names[0]));
	s = "\"";
	net_write_sock (sock, s, schedwi_strlen (s));
	if (client_names[1] != NULL) {
		i = (strcmp (client_names[0], client_names[1]) == 0) ? 2 : 1;
		if (client_names[i] != NULL) {
			s = ", \"dns\" : [ ";
			net_write_sock (sock, s, schedwi_strlen (s));
			first = 1;
			do {
				if (first == 0) {
					s = ", \"";
				}
				else {
					first = 0;
					s = "\"";
				}
				net_write_sock (sock, s, schedwi_strlen (s));
				net_write_sock (sock, client_names[i],
					schedwi_strlen (client_names[i]));
				s = "\"";
				net_write_sock (sock, s, schedwi_strlen (s));
				i++;
			} while (client_names[i] != NULL);
			s = " ]";
			net_write_sock (sock, s, schedwi_strlen (s));
		}
	}
	s = " } }";
	net_write_sock (sock, s, schedwi_strlen (s));

	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
