/* Schedwi
   Copyright (C) 2007-2011 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* reg_getca.c -- Parse the `getca' request */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <lib_functions.h>
#include <net_utils_sock.h>
#include <cert_ca.h>
#include <cert_utils.h>
#include <conf.h>
#include <lwc_log.h>
#include <reg_getca.h>


static void
send_error (int sock, const char *error_message)
{
	char *s;

	s = "{ \"success\" : false, \"data\" : \"";
	net_write_sock (sock, s, schedwi_strlen (s));
	if (error_message != NULL) {
		net_write_sock (sock, error_message,
				schedwi_strlen (error_message));
	}
	else {
		s = _("Cannot get the CA certificate");
		net_write_sock (sock, s, schedwi_strlen (s));
	}
	s = "\" }";
	net_write_sock (sock, s, schedwi_strlen (s));
}


int
reg_getca (	int sock, const char *buff, ssize_t buff_len,
		const char *const *client_names)
{
	char *s, *serialized;
	const char *ca_crt;
	int ret;
	size_t len;

	ret = conf_get_param_string ("SSLCACertificateFile", &ca_crt);
#if HAVE_ASSERT_H
	assert (ret == 0);
#endif

	s = read_file (ca_crt, &len);
	if (s == NULL) {
		send_error (sock, NULL);
		return -1;
	}

	serialized = PEM2string (s);
	free (s);
	if (serialized == NULL) {
		lwc_writeLog (LOG_CRIT, _("Memory allocation error"));
		send_error (sock, NULL);
		return -1;
	}

	s = "{ \"success\" : true, \"data\" : \"";
	net_write_sock (sock, s, schedwi_strlen (s));
	net_write_sock (sock, serialized, schedwi_strlen (serialized));
	free (serialized);
	s = "\" }";
	net_write_sock (sock, s, schedwi_strlen (s));

	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
