/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* module.h -- Modules management functions */

#ifndef _MODULE_H
#define _MODULE_H

#include <schedwi.h>
#include <schedwi_jobtree.h>
#include <job_status_state.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int module_init OF(());
extern void module_exit OF(());
extern int module_path OF((const char *path));
extern int module_load OF((const char *file));
extern int module_conf OF((	const char *name,
				const char *key, const char *value));
extern int module_status OF((	int workload,
				const schedwi_jobtree_node_ptr job,
				job_status_state old_status,
				job_status_state new_status));
extern int module_check OF((	int workload,
				const schedwi_jobtree_node_ptr job));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* module.h */

/*-----------------============== End Of File ==============-----------------*/
