# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKeyConstraint, ForeignKey
from sqlalchemy.types import Integer

from base import Base


class host_environment_s(Base):
    __tablename__ = 'host_environment_s'
    __table_args__ = (
            ForeignKeyConstraint(['env_id', 'workload_date'],
                        ['environments_s.id', 'environments_s.workload_date']),
            {})

    host_id = Column(Integer, ForeignKey('hosts.id'), primary_key=True)
    env_id = Column(Integer, primary_key=True)
    position = Column(Integer)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, env_id, position, workload_date):
        self.env_id = env_id
        self.position = position
        self.workload_date = workload_date

    def copy(self):
        return host_environment_s(self.env_id, self.position,
                                  self.workload_date)
