# Schedwi
# Copyright (C) 2011, 2012 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy.schema import Column, ForeignKey
from sqlalchemy.types import Integer, String

from base import Base, convert2unicode


class environment_var(Base):
    __tablename__ = 'environment_var'

    env_id = Column(Integer, ForeignKey('environments.id'), primary_key=True)
    position = Column(Integer, primary_key=True)
    env_key = Column(String(255))
    env_value = Column(String(255))

    def __init__(self, position, env_key, env_value):
        self.position = position
        self.env_key = convert2unicode(env_key)
        self.env_value = convert2unicode(env_value)

    def copy(self):
        return environment_var(self.position, self.env_key, self.env_value)
