# Schedwi
# Copyright (C) 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Localization functions."""

import gettext

from babel.core import Locale

import config

# List of available translations.  Must be probably sorted by the order
# of most used languages on Internet.  This list is displayed below the
# login form.
available_translations = ['en_US', 'fr_FR']

# List of countries alphabetically sorted
territories = [
["Argentina", "es_AR"],
["Australia", "en_AU"],
["Austria", "de_AT"],
["Bangladesh", "bn_BD"],
["Belgium", "en_BE", "de_BE", "nl_BE", "fr_BE"],
["Belgium", "fr_BE"],
["Brazil", "pt_BR"],
["Canada", "en_CA", "fr_CA"],
["Chile", "es_CL"],
["China", "zh_CN", "ii_CN", "ug_CN", "mn_CN"],
["Colombia", "es_CO"],
["Czech Republic", "cs_CZ"],
["Denmark", "da_DK"],
["Ecuador", "es_EC"],
["Finland", "fi_FI", "sv_FI", "se_FI"],
["France", "fr_FR"],
["Germany", "de_DE"],
["Hong Kong", "en_HK", "zh_HK"],
["India", "en_IN", "te_IN", "kn_IN", "ta_IN", "bn_IN", "pa_IN", "ne_IN",
          "kok_IN", "mr_IN", "hi_IN", "ml_IN", "or_IN", "gu_IN", "ur_IN",
          "as_IN", "sa_IN"],
["Indonesia", "id_ID"],
["Ireland", "en_IE", "ga_IE"],
["Israel", "he_IL"],
["Italy", "it_IT"],
["Japan", "ja_JP"],
["Korea", "ko_KR"],
["Lithuania", "lt_LT"],
["Luxembourg", "fr_LU", "de_LU"],
["Malaysia", "ms_MY"],
["Mexico", "es_MX"],
["Netherlands", "nl_NL"],
["New Zealand", "en_NZ"],
["Norway", "nb_NO", "se_NO", "nn_NO"],
["Pakistan", "en_PK", "pa_PK", "ur_PK"],
["Paraguay", "es_PY"],
["Peru", "es_PE"],
["Philippines", "en_PH", "fil_PH"],
["Portugal", "pt_PT"],
["Russia", "ru_RU", "tt_RU"],
["Singapore", "en_SG", "zh_SG"],
["South Africa", "en_ZA", "ve_ZA", "nso_ZA", "ts_ZA", "xh_ZA", "ss_ZA",
                 "tn_ZA", "zu_ZA", "af_ZA", "nr_ZA", "st_ZA"],
["Spain", "es_ES", "gl_ES", "eu_ES", "ca_ES"],
["Sri Lanka", "si_LK"],
["Sweden", "sv_SE"],
["Switzerland", "fr_CH", "de_CH", "it_CH"],
["Taiwan", "zh_TW"],
["Thailand", "th_TH"],
["United Arab Emirates", "ar_AE"],
["United Kingdom", "en_GB"],
["United States", "en_US", "es_US"],
["Uruguay", "es_UY"],
["Venezuela", "es_VE"],
["Vietnam", "vi_VN"]
]


def get_locale():
    """Get the current locale object.

    @return:    The L{babel.core.Locale} object.
    """
    if not hasattr(get_locale, "locale"):
        get_locale.locale = Locale.default()
    return get_locale.locale


def set_locale(l):
    """Set the current locale.

    @param l:   the locale string ('en_US', 'fr_CA', ...)
    """
    get_locale.locale = Locale.parse(l)
    try:
        t = gettext.translation(config.PACKAGE, config.LOCALEDIR, [str(l)],
                                codeset='utf-8')
    except:
        t = gettext.translation(config.PACKAGE, config.LOCALEDIR,
                                fallback=True)
    t.install()
