# Schedwi
# Copyright (C) 2012, 2013 Herve Quatremain
#
# This file is part of Schedwi.
#
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to remove dependency links between jobs and jobsets."""

import sys
import getopt

import path
from help import print_trim
from simple_queries_job import sql_get_job


def usage():
    """Print a usage message on STDOUT."""
    print_trim(_("""Usage: rmln [OPTION] JOB|JOBSET DEST....
Remove the dependency link between JOB|JOBSET and DESTs.

Option:
  -h, --help       display this help.
    """))


def rmln(sql_session, current_cwd, arguments):
    """Remove dependency links.

    @param sql_session:
                SQLAlchemy session.
    @param current_cwd:
                current working directory (jobset)
    @param arguments:
                arguments passed to the command.
    @return:    0 means success. 1 indicates an error.
    """
    try:
        optlist, args = getopt.getopt(arguments, "h",
                       ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write(_("rmln: ") + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    paths = list()
    if args:
        for arg in args:
            p = path.get_paths(sql_session, arg, current_cwd)
            if not p:
                sys.stderr.write(_("rmln: `%s': no such job or jobset\n")
                                 % arg)
                return 1
            paths.extend(p)
    else:
        sys.stderr.write(_("rmln: missing job or jobset operand\n"))
        return 1
    if not paths:
        sys.stderr.write(_("rmln: no such job or jobset\n"))
        return 1
    if len(paths) < 2:
        sys.stderr.write(_("rmln: no enough operand or unknown job/jobset\n"))
        return 1
    source = paths.pop(0)
    session = sql_session.open_session()
    try:
        source_job = sql_get_job(session, source.id[-1])
    except:
        sys.stderr.write(_("rmln: no such source job or jobset\n"))
        sql_session.cancel_session(session)
        return 1
    for p in paths:
        source_job.links = filter(lambda i: i.job_id_destination != p.id[-1],
                                  source_job.links)
    sql_session.close_session(session)
    return 0
