# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.schema import ForeignKeyConstraint

from base import Base

class job_status(Base):
    __tablename__ = 'job_status'
    __table_args__ = (
            ForeignKeyConstraint(['job_id', 'workload_date'],
                                ['job_main_s.id', 'job_main_s.workload_date']),
            {})

    job_id = Column(Integer, primary_key=True)
    status = Column(Integer)
    start_time = Column(Integer)
    retry_num = Column(Integer)
    error_msg = Column(String(255))
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, status, start_time, retry_num, error_msg, workload_date):
        self.status = status
        self.start_time = start_time
        self.retry_num = retry_num
        self.error_msg = error_msg
        self.workload_date = workload_date

    def copy(self):
        return job_status(self.status, self.start_time, self.retry_num,
                          self.error_msg, self.workload_date)

