# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, Boolean, ForeignKey
from sqlalchemy.schema import ForeignKeyConstraint

from base import Base

class job_loadenv_s(Base):
    __tablename__ = 'job_loadenv_s'
    __table_args__ = (
            ForeignKeyConstraint(['job_id', 'workload_date'],
                                ['job_main_s.id', 'job_main_s.workload_date']),
            {})

    job_id  = Column(Integer, primary_key=True)
    loadenv = Column(Boolean)
    workload_date = Column(Integer, primary_key=True)

    def __init__(self, loadenv, workload_date):
        self.loadenv = loadenv
        self.workload_date = workload_date

    def copy(self):
        return job_loadenv_s(self.loadenv, self.workload_date)
