# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sqlalchemy import Column, Integer, Text, Boolean, ForeignKey

from base import Base

class constraint_file(Base):
    __tablename__ = 'constraint_file'

    job_id = Column(Integer, ForeignKey('job_main.id'), primary_key=True)
    host_id = Column(Integer, ForeignKey('hosts.id'), primary_key=True)
    filename = Column(Text, primary_key=True)
    exist = Column(Boolean)

    def __init__(self, host_id, filename, exist):
        self.host_id = host_id
        self.filename = filename
        self.exist = exist

    def __eq__(self, other):
        if self.host_id == other.host_id and self.filename == other.filename:
            return True
        return False

    def __ne__(self, other):
        if self.host_id == other.host_id and self.filename == other.filename:
            return False
        return True

    def copy(self):
        return constraint_file(self.host_id, self.filename, self.exist)
