# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to manage SQLAlchemy sessions."""

from sqlalchemy.orm import sessionmaker
from sqlalchemy import create_engine


class SqlSession(object):

    def __init__(self,			\
                 drivername='sqlite3',	\
                 user='schedwi',	\
                 password=None,		\
                 hostname='localhost',	\
                 dbname='schedwidb',	\
                 dbdir='.'):
        if drivername == 'sqlite3' or drivername == 'sqlite':
            url = 'sqlite:///' + dbdir + '/' + dbname
        else:
            if password:
                path = user + ':' + password + '@' + hostname + '/' + dbname
            else:
                path = user + '@' + hostname + '/' + dbname
            if drivername == 'pgsql':
                url = 'postgresql://' + path
            elif drivername == 'mSQL' or drivername == 'freetds':
                url = 'msql://' + path
            else:
                url = drivername + '://' + path
#        self.engine = create_engine(url, echo=True)
        self.engine = create_engine(url)
        self.Session = sessionmaker(bind=self.engine)

    def open_session(self):
        return self.Session() 

    def close_session(self, session):
        """Commit."""
        session.commit()
 
    def cancel_session(self, session):
        """Rollback."""
        session.rollback()
 
