# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Parse configuration file."""

import re
import os

import config

DBI_DRIVERNAME = config.DEFAULT_DBI_DRIVERNAME
DBI_DBNAME = config.DEFAULT_DBI_DBNAME
DBI_USER = config.DEFAULT_DBI_USER
DBI_PASSWORD = config.DEFAULT_DBI_PASSWORD
DBI_DBHOSTNAME = config.DEFAULT_DBI_DBHOSTNAME
DBI_DBDIR = config.DEFAULT_DBI_DBDIR

def _parse_file(f):
    """Parse the provided opened file."""
    global DBI_DRIVERNAME, DBI_DBNAME, DBI_USER, \
            DBI_PASSWORD, DBI_DBHOSTNAME,DBI_DBDIR 
    for line in f:
        m=re.search(r'^\s*DBI_DRIVERNAME\s*=\s*(.+)$', line)
        if m:
            DBI_DRIVERNAME = m.group(1).rstrip()
            continue
        m=re.search(r'^\s*DBI_DBNAME\s*=\s*(.+)$', line)
        if m:
            DBI_DBNAME = m.group(1).rstrip()
            continue
        m=re.search(r'^\s*DBI_USER\s*=\s*(.+)$', line)
        if m:
            DBI_USER = m.group(1).rstrip()
            continue
        m=re.search(r'^\s*DBI_PASSWORD\s*=\s*(.+)$', line)
        if m:
            DBI_PASSWORD = m.group(1).rstrip()
            continue
        m=re.search(r'^\s*DBI_DBHOSTNAME\s*=\s*(.+)$', line)
        if m:
            DBI_DBHOSTNAME = m.group(1).rstrip()
            continue
        m=re.search(r'^\s*DBI_DBDIR\s*=\s*(.+)$', line)
        if m:
            DBI_DBDIR = m.group(1).rstrip()
            continue

def parse(file=None):
    """Parse the configuration files."""
    for conf in (config.GLOBAL_CONFIG_FILE,
                 config.LOCAL_CONFIG_FILE,
                 os.path.expanduser(config.USER_CONFIG_FILE),
                 file):
        if conf is not None:
            try:
                f = open(conf, 'r')
            except IOError:
                pass
            else:
                _parse_file(f)
                f.close()

if __name__ == "__main__":
    parse()
    print "DBI_DRIVERNAME=", DBI_DRIVERNAME
    print "DBI_DBNAME=", DBI_DBNAME
    print "DBI_USER=", DBI_USER
    print "DBI_PASSWORD=", DBI_PASSWORD
    print "DBI_DBHOSTNAME=", DBI_DBHOSTNAME
    print "DBI_DBDIR=", DBI_DBDIR

