# Schedwi
# Copyright (C) 2011 Herve Quatremain
# 
# This file is part of Schedwi.
# 
# Schedwi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Schedwi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Module to delete environment groups."""

import sys
import getopt

import environments_utils
import whatuses
from help import print_trim

def usage():
    """Print a usage message on STDOUT."""
    print_trim("""Usage: rm ENV...
        Remove each specified environment group.

        Option:
          -h, --help  display this help. 
    """)

def rm(sql_session, arguments, workload=None):
    """Remove environment groups.

    Arguments:
    sql_session -- SQLAlchemy session
    arguments -- list of arguments given to the rm command (list of env groups)
    workload -- workload to use

    """
    try:
        optlist, args = getopt.getopt(arguments, "h", ["help"])
    except getopt.GetoptError, err:
        sys.stderr.write("rm: " + str(err) + "\n")
        return 1
    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            return 0
    if not args:
        sys.stderr.write("rm: missing operand\n")
        return 1
    session = sql_session.open_session()
    error = False
    for a in args:
        env_list = environments_utils.name2env_list(session, a, workload)
        if not env_list:
            sys.stderr.write("rm: `%s': no such environment group\n" % a)
            error = True
        else:
            for e in env_list:
                if whatuses.is_used(session, e, workload):
                    sys.stderr.write(
            "rm: `%s' is used (run `whatuses %s' for more details)\n" % (e, e))
                    error = True
                else:
                    session.delete(e)
    if error:
        sql_session.cancel_session(session)
        return 1
    sql_session.close_session(session)   
    return 0

