/* Schedwi
   Copyright (C) 2007-2010 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * net_utils_sock.h -- Useful network functions (basic socket connection
 * without SSL - which is not available on this host)
 */


#ifndef _NET_UTILS_SOCK_H
#define _NET_UTILS_SOCK_H

#include <schedwi.h>

#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern char *port2number OF((const char *port));
extern int net_server_sock OF((const char *port_number, const char *iface,
				const char *address_family,
				fd_set *sock_set, int *sock_max));
extern int net_accept_sock OF((fd_set *sock_set, int sock_max,
				const char *allow_from));
extern int net_client_sock OF((const char *port_number, const char *hostname));
extern ssize_t net_read_sock OF((int sock, char **buff, size_t *len));
extern int net_read_result_sock OF((int sock, char **result_msg));
extern int net_write_sock OF((int sock, const char *buff, size_t len));
extern int net_close_sock OF((int sock));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_sock.h */

/*-----------------============== End Of File ==============-----------------*/
