/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_interface.c - GTK/Gnome/libglade helper functions */

#include <schedwi.h>

#include <stdio.h>
#include <glade/glade.h>

#include <schedwi_interface.h>

#define GLADE_FILE PACKAGE_DATA_DIR"/gschedwicons/gschedwicons.glade"


/*
 * Create the widget tree from the glade XML file starting at the
 * provided object name
 */
GtkWidget *
schedwi_create_widget (const gchar *name)
{
	GladeXML *gxml;
	GtkWidget *w;

	gxml = glade_xml_new (GLADE_FILE, name, NULL);
	glade_xml_signal_autoconnect (gxml);
	w = glade_xml_get_widget (gxml, name);
	g_object_set_data_full (G_OBJECT (w), "gladexml",
				(gpointer) gxml, 
				g_object_unref);
	return w;
}


/*
 * Retrieve a widget by its name
 * Copyright (C) Bibek Sahu <scorpio@dodds.net>
 */
GtkWidget *
lookup_widget (GtkWidget *widget, const gchar *widget_name)
{
	GladeXML *gxml;
  
	gxml = glade_get_widget_tree (widget);
	return glade_xml_get_widget (gxml, widget_name);
}


/*
 * From libglade
 */
GdkPixbuf *
create_pixbuf (const gchar *filename)
{
	gchar *pathname = NULL;
	GdkPixbuf *pixbuf;
	GError *error = NULL;

	if (!filename || !filename[0])
		return NULL;

	pathname = gnome_program_locate_file (	NULL,
						GNOME_FILE_DOMAIN_APP_PIXMAP,
						filename, TRUE, NULL);
	if (!pathname) {
		g_warning (_("Couldn't find pixmap file: %s"), filename);
		return NULL;
	}

	pixbuf = gdk_pixbuf_new_from_file (pathname, &error);
	if (!pixbuf) {
		fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
			pathname, error->message);
		g_error_free (error);
	}
	g_free (pathname);
	return pixbuf;
}

/*------------------------======= End Of File =======------------------------*/
