/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* conf_gui.c -- Configuration file management functions (server) */

#include <schedwi.h>

#include <stdlib.h>
#include <string.h>

#include <lib_functions.h>
#include <conf.h>
#include <conf_gui.h>

/*
 * Parameter list (order is important - see conf_init_gui())
 */
static conf_param_t param_gui[] = {
	{ "DB_HOST", STRING, {0}, 0, 0, 0},
	{ "DB_USER", STRING, {0}, 0, 0, 0},
	{ "DB_PASSWD", STRING, {0}, 0, 0, 0},
	{ "DB_DATABASE", STRING, {0}, 0, 0, 0},
	{ "DB_PORT", INT, {0}, check_int, 0, 0},
	{ "DB_UNIXSOCKET", STRING, {0}, 0, 0, 0},
	{ 0, INT, {0}, 0, 0, 0}
};


/*
 * Fill the parameter array by interrogating GConf
 *
 * Return:
 *   0 --> No error
 *  -1 --> Memory allocation error
 */
int
conf_init_gui (	const char *host, const char *user, const char *password,
		const char *database, long int port, const char *socket_file)
{
	int ret;
	char *copy_host, *copy_user, *copy_password;
	char *copy_database, *copy_socket_file; 

	copy_host = copy_user = copy_password = NULL;
	copy_database = copy_socket_file = NULL;

	if (host != NULL) {
		copy_host = (char *) malloc (schedwi_strlen (host) + 1);
		if (copy_host == NULL) {
			return -1;
		}
		strcpy (copy_host, host);
	}

	if (user != NULL) {
		copy_user = (char *) malloc (schedwi_strlen (user) + 1);
		if (copy_user == NULL) {
			if (copy_host != NULL) {
				free (copy_host);
			}
			return -1;
		}
		strcpy (copy_user, user);
	}

	if (password != NULL) {
		copy_password = (char *) malloc (schedwi_strlen (password) + 1);
		if (copy_password == NULL) {
			if (copy_host != NULL) {
				free (copy_host);
			}
			if (copy_user != NULL) {
				free (copy_user);
			}
			return -1;
		}
		strcpy (copy_password, password);
	}

	if (database != NULL) {
		copy_database = (char *) malloc (schedwi_strlen (database) + 1);
		if (copy_database == NULL) {
			if (copy_host != NULL) {
				free (copy_host);
			}
			if (copy_user != NULL) {
				free (copy_user);
			}
			if (copy_password != NULL) {
				free (copy_password);
			}
			return -1;
		}
		strcpy (copy_database, database);
	}

	if (socket_file != NULL) {
		copy_socket_file = (char *) malloc (
						  schedwi_strlen (socket_file)
						+ 1);
		if (copy_socket_file == NULL) {
			if (copy_host != NULL) {
				free (copy_host);
			}
			if (copy_user != NULL) {
				free (copy_user);
			}
			if (copy_password != NULL) {
				free (copy_password);
			}
			if (copy_database != NULL) {
				free (copy_database);
			}
			return -1;
		}
		strcpy (copy_socket_file, socket_file);
	}


	conf_destroy ();

	/*
	 * DB_HOST (index 0 in param_gui)
	 */
	param_gui[0].value.value_string = copy_host;
	if (copy_host != NULL) {
		param_gui[0].is_set = 1;
	}

	/*
	 * DB_USER (index 1 in param_gui)
	 */
	param_gui[1].value.value_string = copy_user;
	if (copy_user != NULL) {
		param_gui[1].is_set = 1;
	}

	/*
	 * DB_PASSWD (index 2 in param_gui)
	 */
	param_gui[2].value.value_string = copy_password;
	if (copy_password != NULL) {
		param_gui[2].is_set = 1;
	}

	/*
	 * DB_DATABASE (index 3 in param_gui)
	 */
	param_gui[3].value.value_string = copy_database;
	if (copy_database != NULL) {
		param_gui[3].is_set = 1;
	}

	/*
	 * DB_PORT (index 4 in param_gui)
	 */
	param_gui[4].value.value_int = port;
	param_gui[4].is_set = 1;

	/*
	 * DB_UNIXSOCKET (index 5 in param_gui)
	 */
	param_gui[5].value.value_string = copy_socket_file;
	if (copy_socket_file != NULL) {
		param_gui[5].is_set = 1;
	}

	ret = conf_init (NULL, param_gui);
	if (ret != 0) {
		if (param_gui[0].value.value_string != NULL) {
			free (param_gui[0].value.value_string);
			param_gui[0].value.value_string = NULL;
		}
		param_gui[0].is_set = 0;
		if (param_gui[1].value.value_string != NULL) {
			free (param_gui[1].value.value_string);
			param_gui[1].value.value_string = NULL;
		}
		param_gui[1].is_set = 0;
		if (param_gui[2].value.value_string != NULL) {
			free (param_gui[2].value.value_string);
			param_gui[2].value.value_string = NULL;
		}
		param_gui[2].is_set = 0;
		if (param_gui[3].value.value_string != NULL) {
			free (param_gui[3].value.value_string);
			param_gui[3].value.value_string = NULL;
		}
		param_gui[3].is_set = 0;
		param_gui[4].is_set = 0;
		if (param_gui[5].value.value_string != NULL) {
			free (param_gui[5].value.value_string);
			param_gui[5].value.value_string = NULL;
		}
		param_gui[5].is_set = 0;
	}
	return ret;
}


/*
 * Destroy (free) the content of the parameter array
 */
void
conf_destroy_gui ()
{
	conf_destroy ();
}

/*------------------------======= End Of File =======------------------------*/
