/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* utils.h -- Several functions */

#ifndef _UTILS_H
#define _UTILS_H 1

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern const char *base_name OF((const char *path));
extern void version OF((const char *prog_name));
extern int my_unlink OF((const char *file_name));
extern void sanitise OF((int fd));
extern void clean_process OF(());
extern int go_daemon OF(());
extern int write_pid_file OF((const char *file_name));
extern void close_pid_file OF((const char *file_name));
extern unsigned int copy_ulltostr OF((unsigned long long int v, char *str));
extern int change_user OF((const char *name));
extern int change_group OF((const char *name));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* utils.h */

/*-----------------============== End Of File ==============-----------------*/
