/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_db_checks.c -- Database consistency checks */

#ifndef _SQL_DB_CHECKS_H
#define _SQL_DB_CHECKS_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_check_id OF((const char *table_source,
	const char *field_source,
	const char *table_destination, const char *field_destination,
	const char *field_output,
	int (*callback)(void *, const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_job_main_check_parent OF((
	int (*callback)(void *, const char *, const char *, char, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_job_main_check_calendar OF((
	int (*callback)(void *, const char *, const char *, char, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_job_main_check_time OF((
	int (*callback)(void *, const char *, const char *, char,
			const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_hosts_check_cert OF((
	int (*callback)(void *, const char *, const char *,
			const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_calendars_check_formula OF((
	int (*callback)(void *, const char *, const char *,
			const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_calendars_check_parent OF((
	int (*callback)(void *, const char *, const char *, char, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_environment_var_check_value OF((
	int (*callback)(void *, const char *, const char *, const char *),
	void *user_data,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_delete1 OF((const char *table_name,
	const char *field_name, const char *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_delete2 OF((const char *table_name,
	const char *field_name1, const char *field_name2,
	const char *id1, const char *id2,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_disable_ssl OF((const char *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_fix_cal_id OF((const char *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_fix_start_time OF((const char *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_create_lost_found_jobset OF((
	const char *name, const char *description, int x, int y,
	unsigned long int *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_attach_orphan_job OF((
	const char *id, unsigned long int parent_id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_create_lost_found_cal_folder OF((
	const char *name, const char *description, unsigned long int *id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_attach_orphan_cal OF((
	const char *id, unsigned long int parent_id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

extern unsigned int sql_check_comment_out_formula OF((
	const char *id, const char *new_formula,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_db_checks.h */

/*-----------------============== End Of File ==============-----------------*/
