/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_module_name.c -- Build a module name */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <lib_functions.h>
#include <net_module_name.h>


/*
 * Construct the buffer containing the module name
 */
static void
build_module_name_static (const char *module_name, char buffer[])
{
	schedwi_memset (buffer, 0, SCHEDWI_NET_FUNCTION_LENGHT);
	if (module_name != NULL) {
		strncpy (buffer, module_name, SCHEDWI_NET_FUNCTION_LENGHT);
	}
}


/*
 * Construct the buffer containing the module name.  This buffer must then
 * be sent to the remote socket
 *
 * Return:
 *   The size of the buffer (which must be freed by the caller) or
 *   -1 in case of memory allocation error
 */
int
build_module_name (const char *module_name, char **buffer)
{
	char *ret;

#if HAVE_ASSERT_H
	assert (buffer != NULL);
#endif

	ret = (char *) malloc (SCHEDWI_NET_FUNCTION_LENGHT);
	if (ret == NULL) {
		return -1;
	}
	build_module_name_static (module_name, ret);
	*buffer = ret;
	return SCHEDWI_NET_FUNCTION_LENGHT;
}

/*-----------------============== End Of File ==============-----------------*/
