/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* commands.h -- commands management functions */

#ifndef _COMMANDS_H
#define _COMMANDS_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <schedwi_time.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	COMMAND_UNKNOWN = 0,
        COMMAND_CHANGE_STATUS,
        COMMAND_STOP
} command_t;


struct _command_action {
	schedwi_date workload;
	unsigned long long int job_id;
	command_t cmd;
	int parameter;
	char *user_details;
};
typedef struct _command_action command_action;
typedef struct _command_action *command_action_ptr;

extern int command_done OF((command_action_ptr ptr));
extern int command_failed OF((command_action_ptr ptr));
extern int command_add OF((	schedwi_date workload,
				unsigned long long int job_id,
				const char *username,
				command_t cmd, int parameter, char **err_msg));
extern int command_purge OF((char **err_msg));
extern lwc_LL *command_get_list OF(());
extern void command_destroy_list OF((lwc_LL *list));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* commands.h */

/*-----------------============== End Of File ==============-----------------*/
