/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_jobsets.h -- jobsets management functions */

#ifndef _SQL_JOBSETS_H
#define _SQL_JOBSETS_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_jobset_list OF((int workload_date, lwc_LL **rows,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));
extern unsigned int sql_jobset_get_canvas_size OF((int workload_date,
			const char *jobset_id,
			void (*set_size)(const char *, const char *, void *),
			void *user_data_set_size,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_jobset_set_canvas_size OF((const char *jobset_id,
			int canvas_width, int canvas_height,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_jobset_search OF((int workload_date, const char *search_str,
        int (*find_job)(int, void *, const char *,
			const char *, const char *, const char *),
        void *user_data_find_job,
        void (*error_func)(void *, const char *, unsigned int),
        void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_jobsets.h */

/*-----------------============== End Of File ==============-----------------*/
