/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* env_window_cb.h -- GUI functions for the environment window */

#ifndef _ENV_WINDOW_CB_H
#define _ENV_WINDOW_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_env OF((	GtkTreeView *view,
					const gchar *env_id,
					int workload_date));
extern void env_ok_clicked OF((GtkButton *button));
extern void env_var_top_clicked OF((GtkButton *button));
extern void env_var_bottom_clicked OF((GtkButton *button));
extern void env_var_up_clicked OF((GtkButton *button));
extern void env_var_down_clicked OF((GtkButton *button));
extern void env_var_remove_clicked OF((GtkButton *button));
extern void env_var_add_clicked OF((GtkButton *button));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* env_window_cb.h */

/*-----------------============== End Of File ==============-----------------*/
