/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* child_job.h -- Structure to draw a job/jobset on a GnomeCanvas */

#ifndef _CHILD_JOB_H
#define _CHILD_JOB_H

struct child_job;
typedef struct child_job child_job_t;


#include <schedwi.h>
#include <gtk/gtk.h>
#include <libgnomecanvas/libgnomecanvas.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <link.h>
#include <jobset_item.h>
#include <schedwi_time.h>
#include <job_status_state.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct child_job {
	gchar *id;			/* Job/jobset ID */
	gchar *name;			/* Name (without path) */
	gchar type;			/* Type (0:jobset 1:job) */
	jobset_item_t *parent_jobset;	/* Pointer to the parent jobset */ 

	gdouble x, y, radius;
	gint width, height;
	gboolean selected;
	job_status_state state;

	/* `root' group under which the job/jobset will be drawn */
	GnomeCanvasGroup *canvas_group;
	/* Job/jobset name item */
	GnomeCanvasItem *canvas_name;
	/* Background rectangle below the name item when job/jobset selected */
	GnomeCanvasItem *canvas_name_bg;
	GnomeCanvasItem *canvas_name_bg_left;
	GnomeCanvasItem *canvas_name_bg_right;
	/* Icon */
	GnomeCanvasItem *canvas_icon;

	GdkPixbuf *icon[NUM_JOB_STATUS_STATE][NUM_HIGHLIGHT_MODES];

	/* Links connected with this job/jobset */
	GSList *links_out;
	GSList *links_in;

	/* Running details */
	schedwi_time run_time;    /* Start date and time of this job/jobset */
	schedwi_time start_time;  /* Real start time */
	/* Max number of seconds for this job/jobset to be started */
	long int start_limit;
	/* Max number of seconds for this job/jobset to complete */
	long int max_duration;
        /* Max number of retries if the job/jobset failed */
        int retries;
        /* Current retry number */
        int retry_num;
        /* Number of seconds between retries */
        long int retries_interval;
	/* Average duration */
	long int average_duration;
	/* Completion percentage */
	unsigned short int completion_pct;
	/* Message associated with the status */
	gchar *status_message;
};


extern void destroy_child_job OF((child_job_t *ptr));
extern void destroy_child_job_list OF((GSList *list));
extern child_job_t * new_child_job OF((
		const gchar *id, const gchar *name, gchar type,
		gdouble x, gdouble y,
		jobset_item_t *parent_jobset));
extern GSList *get_child_job_list OF((	const gchar *parent_id,
					jobset_item_t *parent_jobset));
extern gchar *get_child_job_list_ids OF((GSList *list));
extern void child_job_add_link_out OF((child_job_t *ptr, link_t *link));
extern void child_job_add_link_in OF((child_job_t *ptr, link_t *link));
extern child_job_t *child_job_find OF((GSList *jobs, const gchar *id));
extern void child_job_draw OF((	child_job_t *ptr, GnomeCanvasGroup *group));
extern void child_job_select OF((child_job_t *ptr));
extern void child_job_unselect OF((child_job_t *ptr));
extern void child_job_draw_list OF((GSList *list, GnomeCanvasGroup *group));
extern void child_job_menu_statistics OF((GtkMenuItem *item));
extern void child_job_menu_properties OF((GtkMenuItem *item));
extern void child_job_menu_cut OF((GtkMenuItem *item));
extern gboolean child_job_cut OF((child_job_t *ptr));
extern void child_job_menu_copy OF((GtkMenuItem *item));
extern gboolean child_job_copy OF((child_job_t *ptr));
extern void child_job_menu_stop OF((GtkMenuItem *item));
extern void child_job_menu_start OF((GtkMenuItem *item));
extern void child_job_menu_status_completed OF((GtkMenuItem *item));
extern void child_job_menu_status_failed OF((GtkMenuItem *item));
extern void child_job_menu_status_waiting OF((GtkMenuItem *item));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* child_job.h */

/*-----------------============== End Of File ==============-----------------*/
