/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_job_tree.h -- Manage a job/jobset tree in the database */

#ifndef _SQL_JOB_TREE_H
#define _SQL_JOB_TREE_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _sql_job_tree_link;

/* A job/jobset node structure */
struct _sql_job_tree_node {
	struct _sql_job_tree_node *parent, *children;
	struct _sql_job_tree_node *next;

	/* Node ID */
	char *id;

	/* ID of the copied item */
	unsigned long int new_id;

	/* Output links */
	struct _sql_job_tree_link *links;
};
typedef struct _sql_job_tree_node sql_job_tree_node;
typedef struct _sql_job_tree_node *sql_job_tree_node_ptr;

/* A link structure */
struct _sql_job_tree_link {
        struct _sql_job_tree_link *next;
        struct _sql_job_tree_node *linked_node;
        job_status_state required_status;
};
typedef struct _sql_job_tree_link sql_job_tree_link;
typedef struct _sql_job_tree_link *sql_job_tree_link_ptr;


extern void sql_job_tree_destroy OF((sql_job_tree_node_ptr ptr));
extern sql_job_tree_node_ptr sql_job_tree_new OF((
			const char *job_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_tree_delete OF((
			sql_job_tree_node_ptr ptr,
			void (*foreach_func)(const char *, void *),
			void *foreach_func_data,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_tree_copy OF((
			sql_job_tree_node_ptr ptr,
			const char *parent_id,
			long int x,
			long int y,
			unsigned long int *new_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_job_tree.h */

/*-----------------============== End Of File ==============-----------------*/
