/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_job_hierarchy.c -- Retrieve a job/jobset parameters */

#ifndef _SQL_JOB_HIERARCHY_H
#define _SQL_JOB_HIERARCHY_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <sql_common.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _sql_job_hierarchy {
	lwc_LL *parent_hierarchy_list;
	char *job_id;
	void (*error_func)(void *, const char *, unsigned int);
	void *user_data_error_func;
};
typedef struct _sql_job_hierarchy sql_job_hierarchy;
typedef struct _sql_job_hierarchy *sql_job_hierarchy_ptr;


extern sql_job_hierarchy_ptr sql_job_hierarchy_new OF((
			const char *job_id, char only_hierarchy,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern void sql_job_hierarchy_destroy OF((sql_job_hierarchy_ptr ptr));

extern unsigned int sql_job_hierarchy_get OF((
			sql_job_hierarchy_ptr ptr,
			const char *tablename, const char *colnames,
			char ***values, unsigned long int **values_len,
			char ***values_parent,
			unsigned long int **values_parent_len));
extern unsigned int sql_job_hierarchy_get_multi OF((
			sql_job_hierarchy_ptr ptr,
			const char *tablename, const char *colnames,
			const char *sort_colname,
			lwc_LL **values, lwc_LL **values_len,
			lwc_LL **values_parent, lwc_LL **values_parent_len));
extern unsigned int sql_job_hierarchy_env_list OF((
			sql_job_hierarchy_ptr ptr,
			lwc_LL **values, lwc_LL **values_len));
extern unsigned int sql_job_hierarchy_get_by_id OF((
			sql_job_hierarchy_ptr ptr,
			const char *tablename, const char *colnames,
			const char *not_defined,
			char ***values, unsigned long int **values_len,
			char ***values_parent,
			unsigned long int **values_parent_len));

extern unsigned int sql_job_hierarchy_del OF((
			const char *job_id,
			const char *tablename,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_del_job OF((
			const char *job_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_add OF((
			const char *job_id,
			const char *tablename,
			const char *colname,
			const char *value,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_add_icon OF((
			const char *job_id,
			const char *tablename,
			const char *colname,
			const char *image, unsigned long int image_len,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_add_array OF((
			const char *job_id,
			const char *tablename,
			const char *colname,
			lwc_LL *list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_job_hierarchy_add_env OF((
			const char *job_id,
			lwc_LL *list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_add_constraint_files OF((
			const char *job_id,
			lwc_LL *list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_update_job OF((
			const char *job_id,
			const char *name,
			char enabled,
			const char *description,
			const char *cal_id,
			const char *start_time,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_save_job OF((
			const char *parent_id,
			const char *name,
			char type,
			char enabled,
			const char *description,
			long int x,
			long int y,
			const char *cal_id,
			const char *start_time,
			unsigned long int *added_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_job_hierarchy_move OF((
			const char *job_id,
			const char *new_jobset_id,
			long int x,
			long int y,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_job_hierarchy.h */

/*-----------------============== End Of File ==============-----------------*/
