/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_host_env.h -- host_environment table management functions */

#ifndef _SQL_HOST_ENV_H
#define _SQL_HOST_ENV_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_hosts_env_list OF((
			const char *host_id,
			lwc_LL **rows,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_hosts_env_delete OF((
			const char *host_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_hosts_env_add OF((
			const char *host_id,
			lwc_LL *list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_host_env.h */

/*-----------------============== End Of File ==============-----------------*/
