/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_interface.h - GTK/Gnome/libglade helper functions */

#ifndef _SCHEDWI_INTERFACE_H
#define _SCHEDWI_INTERFACE_H

#include <schedwi.h>
#include <gnome.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *schedwi_create_widget OF((const gchar *name));
extern GtkWidget *lookup_widget OF((	GtkWidget *widget,
					const gchar *widget_name));
extern GdkPixbuf *create_pixbuf OF((const gchar *filename));

#define create_application_main()	schedwi_create_widget("application_main")
#define create_dialog_job()	schedwi_create_widget("dialog_job")
#define create_menu_job()		schedwi_create_widget("menu_job")
#define create_dialog_host_list()	schedwi_create_widget("dialog_host_list")
#define create_dialog_host()	schedwi_create_widget("dialog_host")
#define create_dialog_host_references()	schedwi_create_widget("dialog_host_references")
#define create_dialog_env_choose()	schedwi_create_widget("dialog_env_choose")
#define create_dialog_env_list()	schedwi_create_widget("dialog_env_list")
#define create_dialog_env()	schedwi_create_widget("dialog_env")
#define create_dialog_certificate()	schedwi_create_widget("dialog_certificate")
#define create_menu_cal_list()	schedwi_create_widget("menu_cal_list")
#define create_dialog_cal_list()	schedwi_create_widget("dialog_cal_list")
#define create_dialog_cal()	schedwi_create_widget("dialog_cal")
#define create_dialog_cal_folder()	schedwi_create_widget("dialog_cal_folder")
#define create_dialog_cal_new_question()	schedwi_create_widget("dialog_cal_new_question")
#define create_menu_host_list()	schedwi_create_widget("menu_host_list")
#define create_menu_env_list()	schedwi_create_widget("menu_env_list")
#define create_window_navigator()	schedwi_create_widget("window_navigator")
#define create_dialog_find()	schedwi_create_widget("dialog_find")
#define create_dialog_preferences()	schedwi_create_widget("dialog_preferences")
#define create_dialog_database_test()	schedwi_create_widget("dialog_database_test")
#define create_window_druid()	schedwi_create_widget("window_druid")
#define create_dialog_login()	schedwi_create_widget("dialog_login")
#define create_dialog_background()	schedwi_create_widget("dialog_background")
#define create_menu_background()	schedwi_create_widget("menu_background")
#define create_dialog_statistics()	schedwi_create_widget("dialog_statistics")
#define create_menu_link()	schedwi_create_widget("menu_link")
#define create_window_job_tooltips()	schedwi_create_widget("window_job_tooltips")



#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_interface.h */

/*------------------------======= End Of File =======------------------------*/
