/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* references_cb.h -- GUI functions for the references window */

#ifndef _REFERENCES_CB_H
#define _REFERENCES_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_host_references OF((
				const gchar *host_id,
				const gchar *host_name,
				const gchar *portnum));
extern GtkWidget *new_dialog_env_references OF((
				const gchar *env_id,
				const gchar *env_name));
extern GtkWidget *new_dialog_cal_references OF((
				const gchar *cal_name,
				lwc_LL *list_job));
extern GtkWidget *new_error_dialog_host_references OF((
				const gchar *host_name,
				const gchar *portnum,
				lwc_LL *list_job, lwc_LL *list_file));
extern GtkWidget *new_error_dialog_env_references OF((
				const gchar *name,
				lwc_LL *list_job, lwc_LL *list_host));
extern GtkWidget *new_error_dialog_cal_references OF((
				const gchar *error_message,
				lwc_LL *list_job));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* references_cb.h */

/*-----------------============== End Of File ==============-----------------*/
