/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* job_tooltips.h -- Tooltips for the job and jobset canvas items */

#ifndef _JOB_TOOLTIPS_H
#define _JOB_TOOLTIPS_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _job_tooltips {
	GtkWidget *tip_window;
	GtkWidget *tip_label_title;
	GtkWidget *tip_label_0;
	GtkWidget *tip_value_0;
	GtkWidget *tip_label_1;
	GtkWidget *tip_value_1;
	GtkWidget *tip_label_2;
	GtkWidget *tip_value_2;
	GtkWidget *tip_label_3;
	GtkWidget *tip_value_3;
	GtkWidget *tip_label_4;
	GtkWidget *tip_value_4;
	GtkWidget *widget;
	gint timer_tag;
};
typedef struct _job_tooltips job_tooltips;
typedef struct _job_tooltips *job_tooltips_ptr;

extern job_tooltips_ptr job_tooltips_new OF(());
extern void job_tooltips_destroy OF((job_tooltips_ptr tooltips));
extern void job_tooltips_start OF((job_tooltips_ptr tooltips,
				GtkWidget *widget,
				const gchar *title,
				const char *label_0, const char *value_0,
				const char *label_1, const char *value_1,
				const char *label_2, const char *value_2,
				const char *label_3, const char *value_3,
				const char *label_4, const char *value_4));
extern void job_tooltips_stop OF((job_tooltips_ptr tooltips));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_tooltips.h */

/*-----------------============== End Of File ==============-----------------*/
