/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* cursor.c -- Display a busy mouse pointer */

#include <schedwi.h>

#include <gdk/gdk.h>

#include <main_cb.h>
#include <cursor.h>

static GdkCursor *watch_cursor = NULL;
static GdkCursor *grab_cursor = NULL;

void
cursor_busy (GtkWidget *w)
{
	GtkWidget *toplevel;

	if (watch_cursor == NULL) {
		watch_cursor = gdk_cursor_new (GDK_WATCH);
	}

	if (w == NULL) {
		w = application_main;
	}

	toplevel = gtk_widget_get_toplevel (w);
	if (GTK_WIDGET_TOPLEVEL (toplevel)) {
		gdk_window_set_cursor (toplevel->window, watch_cursor);
		gdk_display_flush (gtk_widget_get_display (toplevel));
	}
}

void
cursor_grab (GtkWidget *w)
{
	GtkWidget *toplevel;

	if (grab_cursor == NULL) {
		grab_cursor = gdk_cursor_new (GDK_FLEUR);
	}

	toplevel = gtk_widget_get_toplevel (w);
	if (GTK_WIDGET_TOPLEVEL (toplevel)) {
		gdk_window_set_cursor (toplevel->window, grab_cursor);
		gdk_display_flush (gtk_widget_get_display (toplevel));
	}
}

GdkCursor *
cursor_get_grab ()
{
	if (grab_cursor == NULL) {
		grab_cursor = gdk_cursor_new (GDK_FLEUR);
	}
	return grab_cursor;
}

void
cursor_normal (GtkWidget *w)
{
	GtkWidget *toplevel;

	if (w == NULL) {
		w = application_main;
	}

	toplevel = gtk_widget_get_toplevel (w);
	if (GTK_WIDGET_TOPLEVEL (toplevel)) {
		gdk_window_set_cursor (toplevel->window, NULL);
	}
}

void
cursor_cleanup ()
{
	if (watch_cursor != NULL) {
		gdk_cursor_unref (watch_cursor);
		watch_cursor = NULL;
	}
	if (grab_cursor != NULL) {
		gdk_cursor_unref (grab_cursor);
		grab_cursor = NULL;
	}
}

/*------------------------======= End Of File =======------------------------*/
