/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* cache_pixbuf.h -- Functions to add an retrieve pixbufs form a cache */

#ifndef _CACHE_PIXBUF_H
#define _CACHE_PIXBUF_H

#include <schedwi.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void empty_cache_pixbuf OF(());
extern gboolean add_pixbuf_to_cache OF((
			const char *stream, unsigned long int len,
			GdkPixbuf **pixbuf,
			GdkPixbuf **pixbuf_high,
			GdkPixbuf **pixbuf_select,
			GdkPixbuf **pixbuf_select_high,
			GdkPixbuf **pixbuf_cut,
			gchar **err_msg));
extern void get_color_from_cache OF((
			job_status_state t,
			const GdkColor **normal,
			const GdkColor **high,
			const GdkColor **select,
			const GdkColor **select_high));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* cache_pixbuf.h */

/*-----------------============== End Of File ==============-----------------*/
