/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* background_cb.h -- GUI functions for the Canvas Properties window */

#ifndef _BACKGROUND_CB_H
#define _BACKGROUND_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_background OF((	const gchar *host_id,
						void (*refresh_func)(void *),
						void *refresh_func_user_data));
extern void background_cb_toggled OF((GtkToggleButton *togglebutton));
extern void background_cb_size_ratio_clicked OF((GtkButton *button));
extern void background_cb_width_changed_cb OF((GtkSpinButton *spin));
extern void background_cb_height_changed_cb OF((GtkSpinButton *spin));
extern void background_cb_upload_clicked OF((GtkButton *button));
extern void background_cb_delete_clicked OF((GtkButton *button));
extern void background_cb_save_clicked OF((GtkButton *button));
extern void background_cb_ok OF((GtkButton *button));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* background_cb.h */

/*-----------------============== End Of File ==============-----------------*/
