/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* conf_srv.c -- Configuration file management functions (srv) */

#include <schedwi.h>
#include <conf.h>
#include <conf_srv.h>

/*
 * Parameter list
 */
static conf_param_t params_clnt[] = {
	{ "USER", STRING, {0}, 0, 0, 0},
	{ "GROUP", STRING, {0}, 0, 0, 0},
	{ "LOG_FILE", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_LOGFILE},
	{ "SYSLOG", SYSLOG_FACILITY, {0}, check_syslog_facility, 0, 0},
	{ "DATE_FORMAT", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_DATEFORMAT},
	{ "PID_FILE", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_PIDFILE},
	{ "WORKLOAD_PURGE_COMPLETED", INT, {0}, check_int, 0, SCHEDWI_DEFAULT_WORKLOAD_PURGE_COMPLETED},
	{ "WORKLOAD_PURGE_FAILED", INT, {0}, check_int, 0, SCHEDWI_DEFAULT_WORKLOAD_PURGE_FAILED},
	{ "SERVER_PORT", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SRVPORT},
	{ "IFACE_LISTEN", STRING, {0}, 0, 0, 0},
	{ "SSLServerCertificateFile", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SSL_SERVER_CERTIFICATE_FILE},
	{ "SSLServerCertificateKeyFile", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SSL_SERVER_CERTIFICATE_KEY_FILE},
	{ "DB_HOST", STRING, {0}, 0, 0, 0},
	{ "DB_USER", STRING, {0}, 0, 0, 0},
	{ "DB_PASSWD", STRING, {0}, 0, 0, 0},
	{ "DB_DATABASE", STRING, {0}, 0, 0, 0},
	{ "DB_PORT", INT, {0}, check_int, 0, 0},
	{ "DB_UNIXSOCKET", STRING, {0}, 0, 0, 0},
	{ 0, INT, {0}, 0, 0, 0}
};

/*
 * Fill the parameter array by reading the provided configuration file
 *
 * Return:
 *   0 --> No error
 *  -1 --> Memory allocation error
 *  -2 --> System error while accessing the configuration file (errno is set)
 *  -3 --> Syntax error in the configuration file.  The errors are sent to
 *	 stderr
 */
int
conf_init_srv (const char *file_name)
{
	return conf_init (file_name, params_clnt);
}


/*
 * Destroy (free) the content of the parameter array
 */
void
conf_destroy_srv ()
{
	conf_destroy ();
}

/*------------------------======= End Of File =======------------------------*/
