/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*
 * net_utils_sock.h -- Useful network functions (basic socket connection
 * without SSL - which is not available on this host)
 */


#ifndef _NET_UTILS_SOCK_H
#define _NET_UTILS_SOCK_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int net_server_sock OF((const char *port_number, const char *iface));
extern int net_accept_sock OF((int sock, const char *schedwi_server_name));
extern int net_client_sock OF((const char *port_number, const char *hostname));
extern ssize_t net_read_sock OF((int sock, char **buff, size_t *len));
extern int net_read_result_sock OF((int sock, char **result_msg));
extern int net_write_sock OF((int sock, const char *buff, size_t len));
extern int net_write_eof_sock OF((int sock));
extern int net_close_sock OF((int sock));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_sock.h */

/*-----------------============== End Of File ==============-----------------*/
