/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* net_module_version.c -- Module to get the client version */

#include <schedwi.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if STDC_HEADERS
#include <string.h>
#endif

#include <lib_functions.h>
#include <net_module_version.h>


/*
 * Send the client version to the network client
 *
 * Return:
 *   Always 0
 */
int
get_version (net_id *sock, char *buffer, size_t size)
{
	net_write (sock, PACKAGE_VERSION, schedwi_strlen (PACKAGE_VERSION));
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
