/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* net_module_clnt.c -- Load the client modules */

#include <schedwi.h>

#include <net_module_runjob.h>
#include <net_module_killjob.h>
#include <net_module_testfile.h>
#include <net_module_joblist.h>
#include <net_module_version.h>

#include <net_module.h>
#include <net_module_clnt.h>

int
module_load_clnt ()
{
	if (	   add_module ("runjob-0.1", run_job) != 0
		|| add_module ("killjob-0.1", kill_jobs) != 0
		|| add_module ("testfile-0.1", test_file) != 0
		|| add_module ("joblist-0.1", get_joblist) != 0
		|| add_module ("version", get_version) != 0)
	{
		destroy_modules ();
		return -1;
	}
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
