/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* conf_clnt.c -- Configuration file management functions (client) */

#include <schedwi.h>
#include <conf.h>
#include <conf_clnt.h>

/*
 * Parameter list
 */
static conf_param_t params_clnt[] = {
	{ "LOG_FILE", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_LOGFILE},
	{ "SYSLOG", SYSLOG_FACILITY, {0}, check_syslog_facility, 0, 0},
	{ "DATE_FORMAT", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_DATEFORMAT},
	{ "PID_FILE", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_PIDFILE},
	{ "SERVER", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SERVER},
	{ "SERVER_PORT", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SRVPORT},
	{ "AGENT_PORT", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_AGTPORT},
	{ "IFACE_LISTEN", STRING, {0}, 0, 0, 0},
	{ "RESULT_DIR", STRING, {0}, check_dirname, 0, SCHEDWI_DEFAULT_RESULTDIR},
	{ "RESULT_PREFIX", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_RESULTPREFIX},
	{ "RESULT_SUFFIX", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_RESULTSUFFIX},
	{ "SSLEngine", BOOL, {0}, check_bool, 0, SCHEDWI_DEFAULT_SSL_ENGINE},
	{ "SSLClientCertificateFile", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SSL_CLIENT_CERTIFICATE_FILE},
	{ "SSLClientCertificateKeyFile", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SSL_CLIENT_CERTIFICATE_KEY_FILE},
	{ "SSLServerCertificateFile", STRING, {0}, 0, 0, SCHEDWI_DEFAULT_SSL_SERVER_CERTIFICATE_KEY_FILE},
	{ 0, INT, {0}, 0, 0, 0}
};


/*
 * Fill the parameter array by reading the provided configuration file
 *
 * Return:
 *   0 --> No error
 *  -1 --> Memory allocation error
 *  -2 --> System error while accessing the configuration file (errno is set)
 *  -3 --> Syntax error in the configuration file.  The errors are sent to
 *         stderr
 */
int
conf_init_clnt (const char *file_name)
{
	return conf_init (file_name, params_clnt);
}


/*
 * Destroy (free) the content of the parameter array
 */
void
conf_destroy_clnt ()
{
	conf_destroy ();
}

/*------------------------======= End Of File =======------------------------*/
