/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* workload.h -- Workloads management functions */

#ifndef _WORKLOAD_H
#define _WORKLOAD_H

#include <schedwi.h>
#include <gtk/gtk.h>

#include <child_job.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern gboolean workload_init_combo OF((GtkComboBox *combo));
extern void workload_set_jobset OF((	GtkComboBox *combo,
					jobset_item_t *current_jobset));
extern void workload_clear OF((GtkComboBox *combo));
extern void workload_changed OF((GtkComboBox *combo));
extern void workload_update_interval OF((GtkSpinButton *spinbutton));
extern guint32 workload_get_workload OF((GtkWidget *w));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* workload.h */

/*-----------------============== End Of File ==============-----------------*/
