/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_where_used.c -- Retrieve references of objects associated with others */

#ifndef _SQL_WHERE_USED_H
#define _SQL_WHERE_USED_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
        JOBSET = 0,
        JOB,
        HOST,
        FILENAME
} object_type;

struct referenced_object {
	char *name;
	char *id;
	object_type obj_type;
	char *more_data;
};
typedef struct referenced_object referenced_object_t;

extern void destroy_referenced_object OF((referenced_object_t *ptr));
extern int sql_host_job_list OF((int workload_date, 
			const char *host_id, lwc_LL **list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_host_file_list OF((int workload_date,
			const char *host_id, lwc_LL **list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_env_job_list OF((int workload_date,
			const char *env_id, lwc_LL **list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_env_host_list OF((int workload_date,
			const char *env_id, lwc_LL **list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_cal_job_list OF((int workload_date, char **cal_id_array,
			unsigned int len_array,
			lwc_LL **list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_where_used.h */

/*-----------------============== End Of File ==============-----------------*/
