/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_env.h -- environments and environment_var table management functions */

#ifndef _SQL_ENV_H
#define _SQL_ENV_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void sql_env_free_item OF((char **array_env));
extern int sql_env_list OF((
			int workload_date,
			lwc_LL *current_envs,
			int (*add_row)(void *, const char *, const char *),
			void *user_data_add_row,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_env_get_main OF((
			int workload_date,
			const char *env_id,
			void (*set_env_id)(const char *, void *),
			void (*set_env_name)(const char *, void *),
			void (*set_env_descr)(const char *, void *),
			void *user_data_set_env,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_env_update OF((
			const char *env_id,
			const char *name,
			const char *description,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_env_new OF((
			const char *name,
			const char *description,
			unsigned long int *new_env_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern int sql_env_get_variables OF((
		int workload_date,
		const char *env_id,
		int (*add_row)(void *, int, const char *, const char *),
		void *user_data_add_row,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));
extern int sql_env_set_variables OF((
			const char *env_id,
			lwc_LL *list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_env_del_variables OF((
			const char *env_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_env_delete OF((	const char *env_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_env.h */

/*-----------------============== End Of File ==============-----------------*/
